% adds one extra sample
% useful for converting a 255 long vector from diff(256 long vector) to 265 long

function c_interp = interp_odd_to_even(c);

C=fft(c);
[M,N]=size(c);
if min(M,N) > 1
  error('interp_odd_to_even: input must be a vector quanity\n');
end%if
L = max(M,N); % length of vector
C=C(:);
c_interp = ifft([[C(1:ceil(L/2));0;C(ceil(L/2)+1:L)]]);

