%DETERMINES PHYSICAL EXTENT OF A PULSE IN TERMS OF THE 0, 1 and 2  MOMENTS
% 
%                                                        Steve Mann; 1989NOV27
%dt = extent(g); % where "g" is a vector
%
%extent is given by: sqrt(2pi*MSE) and is independent of relative amplitude
%
%rectangular pulse has support = .7236*actual len, regardless of height
%
%extent(ones(1,100)) = extent(2*ones(1,100)) = .7236*100 pixels
%extent(ones(1,1000)) = 723.6 = .7236*1000 pixels
%
%extent is padding invariant:  extent([1 1]) = extent([0 0 0 0 1 1])
%      (both have extent ~=1.25 pixels)
%
%see Gabor, 1945

function dt = extent(g);

%%%timebase = (-(length(g)-1)/2:(length(g)-1)/2)/length(g);
%%%timebase = (1:(length(g)))/length(g); % really same as above, since
%                                       support is invariant to time shift

timebase = 1:(length(g)); % support must be padding insensitive
%                           support([1 1]) must equal support([0 0 1 1])

m0 = sum(conj(g).*g);     % power or energy in original signal
m1 = sum(conj(g(:)).*timebase(:).*g(:));  % center of grav. of |g|.^2
m2 = sum(conj(g(:)).*timebase(:).^2 .*g(:));

Et = m1/m0;
Ett= m2/m0;

dt = (2*pi*(Ett-Et^2)) ^ (1/2);

