% adds extra samples to a sequence of odd length
% useful for converting a 255 long vector from diff(256 long vector) to 256 long
%
% odd number of samples has nothing at fracfreq=1/2 so we can insert zeros there

function c_interp = interp_odd_to(c,padlen);
if nargin<2
  padlen=1;  % by default, insert one additional zero for padding
end%if

C=fft(c);
[M,N]=size(c);
if min(M,N) > 1
  error('interp_odd_to_even: input must be a vector quanity\n');
end%if

L = max(M,N); % length of vector
if round(L/2)*2 == L
  error('interp_odd_to: input must have an odd number of samples\n');
end%if

C=C(:);
pad=zeros(padlen,1);
c_interp = ifft([[C(1:ceil(L/2));pad;C(ceil(L/2)+1:L)]]);

