% tvs.m scaled version of tv()

function tvs(r,g,b);
fname = sprintf("deleteme%07d.pnm",rand*(10^7));
%keyboard
fd = fopen(fname,"w");
[Mr Nr]=size(r);
if nargin==1
  fprintf(fd,"P5\n");
  fprintf(fd,"%d  %d\n",Nr,Mr);
  fprintf(fd,"255\n");
  maxr=max(max(r));
  minr=min(min(r));
  r=round(255.0*(r-minr)/(maxr-minr));
  r = r.';
  fwrite(fd,r,"uchar");
else%if
  [Mg Ng]=size(g);
  [Mb Nb]=size(b);
  if (Mr==Mg) & (Mr==Mb) & (Nr==Ng) & (Nr==Nb)
    M=Mr; N=Nr;  % all the same
    fprintf(fd,"P6\n");
    fprintf(fd,"%d  %d\n",N,M);
    fprintf(fd,"255\n");
    maxr=max(max(r)); minr=min(min(r)); r=round(255.0*(r-minr)/(maxr-minr));
    maxg=max(max(g)); ming=min(min(g)); g=round(255.0*(g-ming)/(maxg-ming));
    maxb=max(max(b)); minb=min(min(b)); b=round(255.0*(b-minb)/(maxb-minb));
    r = r.'; g = g.'; b = b.';
    r = reshape(r,1,M*N);
    g = reshape(g,1,M*N);
    b = reshape(b,1,M*N);
    fwrite(fd,[r;g;b],"uchar");
  else%if
    error("tvs.m: images must be same size")
  end%if
end%if
fclose(fd);
system(sprintf("xv %s &", fname));

%keyboard

