// plot real versus imaginary from a file

// to compile: gcc plotzfile.c -lcomedi -lpanel -lncurses
// to run: ./a.out

// hacked to read from file, e.g. car3.txt
// or stdin???

/*****************************************************************************
 *			University of Toronto
 * (C) Copyright 2000           Taneem Ahmed <taneem@eyetap.org>         
 *****************************************************************************
 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *****************************************************************************/

#include <stdlib.h>
#include <curses.h>
#include <panel.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

#include "rader_plot.h"

#define S_DEBUG(x)	x
#define B_DEBUG		1

int main(int argc, char **argv){
 
  rader_info_ptr r;
  int done=0;
  S_DEBUG(int dummy_x);
  S_DEBUG(int dummy_y);
  int resp;
  char msg[128];
  S_DEBUG(FILE *fake);

  if((r = (rader_info_ptr) malloc(sizeof(rader_info)))==NULL){
     perror("malloc");
     exit(1);
  }
//  strcpy(r->device,RADER_DEVICE);
//  r->fd = open(r->device,O_RDWR);

#ifdef  B_DEBUG
  if(argc>1){
    fake = fopen(argv[1],"r");
    if(!fake){ 
      fprintf(stderr,"%s: %s no such file\n",argv[0],argv[1]);
      exit(1);
    };
  }
  else{
    fake = fopen("car3.txt","r");
    if(!fake){ 
      fprintf(stderr,"%s: %s no such file\n",argv[0],"car3.txt");
      exit(1);
    };
  }
#endif
  start_ncurses(r);
  getmaxyx(r->main_window,r->y_width,r->x_width);
  r->x_factor = RADER_POINTS/r->x_width;
  r->y_factor = RADER_POINTS/r->y_width;

/*
  do{
//  whatever read function needs to be used from comedilib
    read(r->fd,&(r->x_val),1); 
    read(r->fd,&(r->y_val),1); 
*/
  while(!feof(fake)){
#ifdef B_DEBUG
    fscanf(fake,"%d %d",&dummy_x,&dummy_y);
    r->x_val = dummy_x;
    r->y_val = dummy_y;
#endif
 
//    r->x_pos = ((float) r->x_val / r->x_factor) + ((float) r->x_width / 2);
//    r->y_pos = ((float) r->y_val / r->y_factor) + ((float) r->y_width / 2);
    r->x_pos = ((float) r->x_val / r->x_factor);
    r->y_pos = ((float) r->y_val / r->y_factor);
//    sprintf(msg,"pos x = %d, y = %d",r->x_pos,r->y_pos);
    //sprintf(msg,"dummy x = %d, y = %d",dummy_x,dummy_y);
//    print_err(r,msg);
    mvprintw(r->y_pos,r->x_pos,"*");
    refresh();
//    mvprintw(r->y_pos,r->x_pos," "); // puts a blank to delete last point
//    sleep(1);
#ifdef	REAL_STUFF
    resp = getch();
    switch (resp){
      case 'q':
      case 'Q':
        done = 1;
      case '\n':
      case KEY_BACKSPACE:
      case KEY_LEFT:
      case KEY_RIGHT:
      case KEY_DOWN:
      case KEY_UP:
      case '?':
      case KEY_F(1): 
      default:
        break;
    }
  }while(!done);
#endif
  S_DEBUG(});
  stop_ncurses(r);
//  close(r->fd);   /* close the fd for /dev/comedi? */
  S_DEBUG(fclose(fake));
  return 0;
}

int start_ncurses(rader_info_ptr r){

  r->main_window = initscr();
  cbreak();
  noecho();
  nodelay(r->main_window,TRUE);
  keypad(r->main_window,TRUE);
  return 0;
}

int print_err(rader_info_ptr r, const char *msg){
   int x,y;

   getyx(r->main_window,y,x);
   attrset(A_BOLD);
   mvprintw(19,10,"%s",msg);
   attrset(A_NORMAL);
   move(y,x);
   return 0;
}

void stop_ncurses(rader_info_ptr r){

  clear();
  refresh();
  endwin();
}

